/**
    * Modal_Right
    * menu_Modal_Left
    * headerFixed
    * themesflatSearch
    * btn_switch_layout
    * menuAdminActive
    * selectTypeForm
    * niceSelectForm
    * bg_bottom
    * tabFooter
    * goTop
    * removePreloader
 */

(function ($) {
    "use strict";

    var isMobile = {
        Android: function () {
            return navigator.userAgent.match(/Android/i);
        },
        BlackBerry: function () {
            return navigator.userAgent.match(/BlackBerry/i);
        },
        iOS: function () {
            return navigator.userAgent.match(/iPhone|iPad|iPod/i);
        },
        Opera: function () {
            return navigator.userAgent.match(/Opera Mini/i);
        },
        Windows: function () {
            return navigator.userAgent.match(/IEMobile/i);
        },
        any: function () {
            return (
                isMobile.Android() ||
                isMobile.BlackBerry() ||
                isMobile.iOS() ||
                isMobile.Opera() ||
                isMobile.Windows()
            );
        },
    };

    var dashboard_Sidebar = function () {
        const dashboard = $(".sidebar-dashboard");
        var adminbar = $("#wpadminbar").height();
        $(".sidebar-dashboard").css({ top: adminbar });
        if (dashboard.length) {
            const open = function () {
                dashboard.addClass("active");
                $(".dashboard-overlay").addClass("active");
            };
            const close = function () {
                dashboard.removeClass("active");
                $(".dashboard-overlay").removeClass("active");
            };
            $(".dashboard-toggle").on("click", function () {
                open();
            });
            $(".dashboard-overlay, .btn-menu").on(
                "click",
                function () {
                    close();
                }
            );
        }
       
    };
    var Modal_Right = function() {
        const body = $('body');
        const modalMenu = $('.modal-menu-left');
        const modalMenuBody = modalMenu.children('.modal-menu__body');

        if (modalMenu.length) {
            const open = function() {
                modalMenu.addClass('modal-menu--open');
            };
            const close = function() {
                modalMenu.removeClass('modal-menu--open');
            };

            $('.modal-menu-left-btn, .span-modal-menu-left-btn').on('click', function() {
                open();
            });
            $('.modal-menu__backdrop, .modal-menu__close').on('click', function() {
                close();
            });
        }

        modalMenu.on('click', function(event) {
            const trigger = $(this);
            const item = trigger.closest('[data-modal-menu-item]');
            let panel = item.data('panel');

            if (!panel) {
                panel = item.children('[data-modal-menu-panel]').children('.modal-menu__panel');

                if (panel.length) {
                    modalMenuBody.append(panel);
                    item.data('panel', panel);
                    panel.width(); // force reflow
                }
            }

            if (panel && panel.length) {
                event.preventDefault();
            }
        });
    };

    var menu_Modal_Left = function () {
        var menuType = "desktop";

        $(window).on("load resize", function () {
            var currMenuType = "desktop";
            var adminbar = $("#wpadminbar").height();

            currMenuType = "mobile";

            if (currMenuType !== menuType) {
                menuType = currMenuType;

                if (currMenuType === "mobile") {
                    var hasChildMenu = $("#mainnav_canvas").find("li:has(ul)");
                    hasChildMenu.children("ul").hide();
                    if (hasChildMenu.find(">span").length == 0) {
                        hasChildMenu
                            .children("a")
                            .after('<span class="btn-submenu"></span>');
                    }
                    $(".btn-menu").removeClass("active");
                } else {
                    $("#header").find(".canvas-nav-wrap").removeClass("active");
                }
            }
        });

        $(".btn-menu").on("click", function (e) {
            $(this)
                .closest("#header")
                .find(".canvas-nav-wrap")
                .addClass("active");
        });

        $(".canvas-nav-wrap .overlay-canvas-nav").on("click", function (e) {
            $(this)
                .closest("#header")
                .find(".canvas-nav-wrap")
                .removeClass("active");
        });

        $(document).on(
            "click",
            "#mainnav_canvas li .btn-submenu",
            function (e) {
                $(this).toggleClass("active").next("ul").slideToggle(300);
                e.stopImmediatePropagation();
            }
        );
    };

    var themesflatSearch = function () {
        $(document).on("click", function (e) {
            var clickID = e.target.id;
            if (clickID != "s") {
                $(".top-search").removeClass("show");
                $(".show-search").removeClass("active");
            }
        });

        $(".show-search").on("click", function (event) {
            event.stopPropagation();
        });

        $(".search-form").on("click", function (event) {
            event.stopPropagation();
        });

        $(".show-search").on("click", function (e) {
            if (!$(this).hasClass("active")) $(this).addClass("active");
            else $(this).removeClass("active");
            e.preventDefault();

            if (!$(".top-search").hasClass("show"))
                $(".top-search").addClass("show");
            else $(".top-search").removeClass("show");
        });
    };

    var menuAdminActive = function () {

        $(window).ready(function() {
            var href = window.location.href;
            $('.db-dashboard-menu a, .widget_login_menu_widget .user-dropdown-menu a').each(function(e,i) {
              if (href.indexOf($(this).attr('href')) >= 0) {
                $(this).addClass('active');
              }
            });
        });
    }

    var selectTypeForm = function () {
        if ($(".tfre-login-form").length > 0) {

            $(".tfre-login-form .modal-content .tfre_login_redirect_button, .display-pop-login, .display-pop-login.login").on("click", function () {
                $(this).closest("body").find('.thumb-login').show();
                $(this).closest("body").find('.thumb-register').hide();
            });

            $(".tfre-login-form .modal-content .tfre_register_button, .display-pop-login.register").on("click", function () {
                $(this).closest("body").find('.thumb-register').show();
                $(this).closest("body").find('.thumb-login').hide();
            });

        }
    };

    var headerFixed = function () {
        if ($("body").hasClass("header_sticky")) {
            var header = $("#header"),
                hd_height = $("#header").height(),
                injectSpace = $("<div class='spacing-sticky'></div>").css("height" ,hd_height).insertAfter(
                    $("#header")
                );
            injectSpace.hide();
            $(window).on("load scroll resize", function () {
                    var wpadminbar = $("#wpadminbar").height();
                    $(".canvas-nav-wrap.active .inner-canvas-nav").css("padding-top", wpadminbar);
                    if ($(window).scrollTop() >= hd_height) {
                        header.addClass("fixed-show");
                        injectSpace.show();
                    } else {
                        header.removeClass("fixed-show");
                        injectSpace.hide();
                    }
                    if ( $(window).scrollTop() > 500 ) {
                        header.addClass('header-sticky');
                        $(".header-sticky").css("top", wpadminbar);
                    } else {
                        $(".header-sticky").removeAttr("style");
                        header.removeClass('header-sticky');
                    }
                    if($(window).scrollTop() >= wpadminbar) {
                        $(".canvas-nav-wrap.active .inner-canvas-nav").addClass('hide-padding');
                    }else {
                        $(".canvas-nav-wrap.active .inner-canvas-nav").removeClass('hide-padding');
                    }
            });
        }
    };

    var niceSelectForm = function () {
        if ($("select").length > 0) {
            $("select").niceSelect();
        }
    };

    var tabFooter = function () {
        if ($(".menu-tab-footer").length > 0) {
        $(document).ready(function () {
            $(window).on("resize load", function (e) {
                var newWindowWidth = $(window).width();
                if (newWindowWidth < 767) {
                    for(var i = 1; i < 5; i++) {
                        var item = $("#footer .wrap-widgets-"+i);
                        item.find(".widget-title").insertBefore(item);
                    }
                    $("#footer .footer-widgets .widgets-areas > .widget-title").on("click", function () {
                        $(this).toggleClass("active");
                        $(this).closest(".widgets-areas").find(".wrap-widgets").toggleClass("active");
                    });
                    $("#footer .widgets-areas").find(".widget-title").closest('.widgets-areas').addClass('has-tab');
                }
            });
        });
        }

    };

    var singleClassBlog = function () {
        if ($(".blog-post.blog-single").length > 0) {
            $("body").addClass("blog-layout-fullwidth");
        }
        if ($(".blog-post.has-post-thumbnail").length > 0) {
            $("body").addClass("has-post-thumbnail");
        }
    };

    var goTop = function () {
        $(window).scroll(function () {
            if ($(this).scrollTop() > 500) {
                $(".go-top").addClass("show");
            } else {
                $(".go-top").removeClass("show");
            }
        });
        $(".go-top").on("click", function (event) {
            event.preventDefault();
            $("html, body").animate({ scrollTop: 0 }, 0);
        });
    };

    var onClickTypeListView = function (buttonClass, viewType) {
        $(buttonClass).on("click",function (event) {
            event.preventDefault();
            localStorage.setItem('TYPE_BLOG_VIEW', viewType);
            var $this = $(this);
            var styleLayout = $this.data('style-layout');
            $(".wrap-blog-article .item").removeClass(function (index, className) {
                return (className.match(/\bstyle\S+/g) || []).join(' ');
            });
            checkTypePropertiesView(styleLayout);
        });
    };

    var checkTypePropertiesView = function (styleLayout) {
        var type = localStorage.getItem('TYPE_BLOG_VIEW');
        switch (type) {
            case 'grid':
                styleLayout = $('.btn-display-blog-grid').data('style-layout');
                $('.wrap-blog-article').removeClass('list');
                $('.wrap-blog-article').addClass(styleLayout);
                $('.btn-display-blog-grid').addClass('active');
                $('.btn-display-blog-list').removeClass('active');
                break;
            case 'list':
                styleLayout = $('.btn-display-blog-list').data('style-layout');
                $('.wrap-blog-article').removeClass('grid');
                $('.wrap-blog-article').addClass(styleLayout);
                $('.btn-display-blog-list').addClass('active');
                $('.btn-display-blog-grid').removeClass('active');
                break;
            default:
                break;
        }
    };

    var carouselRelatedPost = function () {
        if($('.related-posts-box').length) {
            $('.owl-carousel').owlCarousel({
                loop:true,
                margin:40,
                nav:false,
                bullet: false,
                responsive:{
                    0:{
                        items:1
                    },
                    600:{
                        items:2
                    },
                    1000:{
                        items:3
                    }
                }
            })
        }
    };

    var activeSidebarPopupMobile = function () {
        if($('.tfcl-popup-sidebar').length) {
            $(document).ready(function () {
                $(window).on("resize load", function (e) {
                    var newWindowWidth = $(window).width();
                    if (newWindowWidth < 992) {
                        $('.tfcl-popup-sidebar').addClass('active-mobile');
                    }else {
                        $('.tfcl-popup-sidebar').removeClass('active-mobile');
                    }
                });
            });
            $(".btn-toggle-sidebar").on("click", function (event) {
                $(this).closest('.tfcl-popup-sidebar').toggleClass('active');
            });
            $(".overlay-sidebar, .tfcl-popup-sidebar .btn-clear-all ").on("click", function (event) {
                $(this).closest('.tfcl-popup-sidebar').removeClass('active');
            });
        }
    };

    var removePreloader = function () {
        $("#preloader").fadeOut("slow", function () {
            setTimeout(function () {
                $("#preloader").remove();
            }, 1000);
        });
    };


    // Dom Ready
    $(function () {
        singleClassBlog();
        dashboard_Sidebar();
        menu_Modal_Left();
        onClickTypeListView('.btn-display-blog-grid', 'grid');
        onClickTypeListView('.btn-display-blog-list', 'list');
        checkTypePropertiesView();
        headerFixed();
        menuAdminActive();
        themesflatSearch();
        selectTypeForm();
        niceSelectForm();
        tabFooter();
        Modal_Right();
        activeSidebarPopupMobile();
        goTop();
        carouselRelatedPost();
        removePreloader();
    });
})(jQuery);


window.addEventListener('scroll', function () {
  const headers = document.querySelectorAll('.stickyhead');

  headers.forEach(header => {
    const sticky = header.offsetTop;

    if (window.scrollY > sticky) {
      header.classList.add('sticky');
    } else {
      header.classList.remove('sticky');
    }
  });
});