;(function($) {

    "use strict";

    var testimonial_Carousel = function() {
        if ( $().owlCarousel ) {
            $('.tf-testimonial-carousel').each(function(){
                var
                $this = $(this),
                item = $this.data("column"),
                item2 = $this.data("column2"),
                item3 = $this.data("column3"),
                spacer = Number($this.data("spacer")),
                prev_icon = $this.data("prev_icon"),
                next_icon = $this.data("next_icon"),
                index_active = $this.data("index_active");

                var loop2 = false;
                if ($this.data("loop") == 'yes') {
                    loop2 = true;
                }

                var center = false;
                if ($this.data("center") == 'yes') {
                    center = true;
                }

                var arrow = false;
                if ($this.data("arrow") == 'yes') {
                    arrow = true;
                } 

                var bullets = false;
                if ($this.data("bullets") == 'yes') {
                    bullets = true;
                }

                var auto = false;
                if ($this.data("auto") == 'yes') {
                    auto = true;
                }    
                
                $('.has-overlay').on('initialized.owl.carousel translate.owl.carousel', function(e){
                    var idx = e.item.index;
                    $(this).find('.owl-item').removeClass('active_overlay');
                    $(this).find('.owl-item').eq(idx+2).addClass('active_overlay');
                });

                $this.find('.owl-carousel').owlCarousel({
                    loop: loop2,
                    margin: spacer,
                    nav: arrow,
                    dots: bullets,
                    autoplay: auto,
                    center: center,
                    autoplayTimeout: 5000,
                    smartSpeed: 850,
                    autoplayHoverPause: true,
                    navText : ["<i class=\""+prev_icon+"\"></i>","<i class=\""+next_icon+"\"></i>"],
                    responsive: {
                        0:{
                            items:item3,
                            center: false
                        },
                        768:{
                            items:item2,
                            center: false
                        },
                        1000:{
                            items:item
                        }
                    }
                });
                
            });
        }
    }

    // Mouse Custom Cursor
    var custom_cursor = function() { 
        var tfCursor = jQuery(".tfmouseCursor");
        if (tfCursor.length) {
        if ($("body")) {
            const e = document.querySelector(".cursor-inner");
            let n,
            i = 0,
            o = !1;
            (window.onmousemove = function (s) {
            o ||
                (e.style.transform =
                "translate(" + s.clientX + "px, " + s.clientY + "px)"),
                (n = s.clientY),
                (i = s.clientX);
            }),
            $("body").on("mouseenter", "button, a, .cursor-pointer, .owl-dots", function () {
                e.classList.add("cursor-hover");
            }),
            $("body").on("mouseleave", "button, a, .cursor-pointer, .owl-dots", function () {
                ($(this).is("a", "button") &&
                $(this).closest(".cursor-pointer").length) ||
                (e.classList.remove("cursor-hover"));
            }),
            (e.style.visibility = "visible");
        }
        }
    }

    var icon_Carousel = function() {
        if ( $().owlCarousel ) {
            $('.tf-icon-carousel').each(function(){
                var
                $this = $(this),
                item = $this.data("column"),
                item2 = $this.data("column2"),
                item3 = $this.data("column3"),
                spacer = Number($this.data("spacer")),
                prev_icon = $this.data("prev_icon"),
                next_icon = $this.data("next_icon");

                var loop = false;
                if ($this.data("loop") == 'yes') {
                    loop = true;
                }

                var arrow = false;
                if ($this.data("arrow") == 'yes') {
                    arrow = true;
                } 

                var bullets = false;
                if ($this.data("bullets") == 'yes') {
                    bullets = true;
                }

                var auto = false;
                if ($this.data("auto") == 'yes') {
                    auto = true;
                }    
                
                $this.find('.owl-carousel').owlCarousel({
                    loop: loop,
                    margin: spacer,
                    nav: arrow,
                    dots: bullets,
                    autoplay: auto,
                    autoplayTimeout: 5000,
                    smartSpeed: 850,
                    autoplayHoverPause: true,
                    navText : ["<i class=\""+prev_icon+"\"></i>","<i class=\""+next_icon+"\"></i>"],
                    responsive: {
                        0:{
                            items:item3
                        },
                        768:{
                            items:item2
                        },
                        1000:{
                            items:item
                        }
                    }
                });
                
            });
        }
    }

    var tfRevert = function () {
        let reveals = document.querySelectorAll('.reveal');
        if (window.innerWidth > 768) {
          $(window).on('scroll', function () {
            reveals.forEach((el) => {
              const windowHeight = window.innerHeight;
              const revealTop = el.getBoundingClientRect().top;
              const elHeight = $(this).height();
              const revealPoint = -150;
              // position & speed 
              const posPoint = 20;
              // attr parent
              el.parentElement.style.perspective = '700px';
              el.parentElement.style.transformStyle = 'preserve-3d';
              el.parentElement.style.perspectiveOrigin = '100% 0%';
              // attr node
              el.style.transformOrigin = '50% 0';
              el.style.translate = 'none';
              el.style.rotate = 'none';
              el.style.scale = 'none';
              el.style.transition = 'all .30s ease';
              // console.log(revealTop > windowHeight - revealPoint);
              if (revealTop > windowHeight - revealPoint ) {
                el.style.opacity = '0';
                el.style.transform = `rotateX(-${posPoint}deg)`
              }
              if (revealTop < windowHeight - revealPoint) {
                if (revealTop > -50) {
                  let schemas = Math.abs(1 - revealTop / elHeight);
                  let opacity = Math.min((Math.abs(1 - (revealTop - 350) / elHeight)), 1);
                  let rotate = Math.min((posPoint * schemas - (posPoint - 10)), 0)
                  el.style.opacity = `${opacity}`;
                  el.style.transform = `translate3d(0px,0px,0px) rotateX(${rotate}deg)`
                }
                else {
                  el.style.transform = `translate(0,0)`
                }
              }
        
            })
          })
        }
        }

    $(window).on('elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/tf-testimonial-carousel.default', testimonial_Carousel );
        elementorFrontend.hooks.addAction( 'frontend/element_ready/tf-testimonial-carousel.default', custom_cursor );
        elementorFrontend.hooks.addAction( 'frontend/element_ready/tf-testimonial-carousel.default', tfRevert );
        elementorFrontend.hooks.addAction( 'frontend/element_ready/tf-icon-carousel.default', icon_Carousel );
    });

})(jQuery);
