(function ($) {

    var loanCalculator = function () {

        $("#interest_rate, #down_payment_percent, #amortization_period").blur(function () {
            if ($(this).val() == "" || $(this).val() == '%') {
                $(this).val(0);
                $('#down_payment').val(0);
            } 
        });

        var val1 = $('#down_payment_percent').val();
        $('#down_payment_percent').val(val1+'%');

        $('#down_payment_percent').on("load ready change", function () {
            var val2 = $(this).val();
              $(this).val(val2+'%');
        });

        $('#btn_loan_calculate, .loan-calculator-form input').on("click change", function () {
            var totalAmount = parseFloat($('#total_amount').val().replace(/,/g, ''), 10);
            var downPayment = parseFloat($('#down_payment').val().replace(/,/g, ''), 10);
            var downPayment_percent = parseFloat($('#down_payment_percent').val().replace(/,/g, ''), 10);
            var amortizationPeriod = parseFloat($('#amortization_period').val().replace(/,/g, ''), 10);
            var interestRate = parseFloat($('#interest_rate').val().replace(/,/g, ''), 10);
            var propertyTax = parseFloat($('#property_tax').val().replace(/,/g, ''), 10);
            var homeInsurance = parseFloat($('#home_insurance').val().replace(/,/g, ''), 10);
            var totalPercent = totalAmount - (totalAmount * ((100 - downPayment_percent) / 100));
            var totalPropertyTax = propertyTax ? propertyTax : 0;
            var totalHomeInsurance = homeInsurance ? homeInsurance : 0;
            $('#down_payment').val(totalPercent);
            totalAmount = downPayment ? totalAmount - downPayment : totalAmount;
            totalAmount = totalAmount + (totalPropertyTax + totalHomeInsurance);

                $('.loan-calculator-form .group-calculator').addClass('active');
                var monthlyPayment = '';
                if (interestRate != 0 && amortizationPeriod != 0) {
                    monthlyPayment = totalAmount * ((interestRate / 100) / 12) / (1 - (Math.pow((1 + (((interestRate / 100) / 12))), -amortizationPeriod)));
                    $('.loan-calculator-form #monthly-payment-value').text(Math.round(monthlyPayment * 100) / 100);
                }else if(interestRate == 0 && amortizationPeriod != 0) {
                    monthlyPayment = totalAmount / amortizationPeriod;
                    $('.loan-calculator-form #monthly-payment-value').text(monthlyPayment);
                }else {
                    monthlyPayment = totalAmount;
                    $('.loan-calculator-form #monthly-payment-value').text(monthlyPayment);
                }
        });

    }

    var addCommaInputNumber = function () {
        $(".loan-calculator-form input[type='text']").keyup(function (event) {
            // skip for arrow keys
            if (event.which >= 37 && event.which <= 40) {
                event.preventDefault();
            }
            $(this).val(function (index, value) {
                return value
                    .replace(/\D/g, "")
                    .replace(/\B(?=(\d{3})+(?!\d))/g, ",");
            });
        });
    }

    var handleResetLoanCalculatorForm = function () {
        $('#btn_loan_reset').click(function () {
            $('.loan-calculator-form .group-calculator').removeClass('active');
            $('#total_amount').val('');
            $('#down_payment').val('');
            $('#down_payment_percent').val('');
            $('#interest_rate').val('');
            $('#amortization_period').val('');
            $('#property_tax').val('');
            $('#home_insurance').val('');
            $('.loan-calculator-form #monthly-payment-value').text('');
        })
    }

    $(document).ready(function () {
        loanCalculator();
        addCommaInputNumber();
        handleResetLoanCalculatorForm();
    })
})(jQuery);